(**********************************************
 **              Form DemoForm               **
 ** ---------------------------------------- **
 **            Image-Edit example            **
 ** ---------------------------------------- **
 **                                          **
 ** Delphi 1.0,2.0 / DEMOFORM.PAS / H.Drner **
 ** created     : 08.08.1996                 **
 ** last update : 18.08.1996                 **
 **                                          **
 **********************************************)

unit Demoform;

{=============================================}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, Menus, ExtCtrls, Mask,
  DBCtrls, DB, DBTables, TabNotBk, Buttons,Imgedit, Imgdbed, FileCtrl;

type
  TFormDemo = class(TForm)
    PanelTop: TPanel;
    PanelClient: TPanel;
    Label9: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    TabbedNotebook1: TTabbedNotebook;
    ScrollBox1: TScrollBox;
    Table1: TTable;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ScrollBox2: TScrollBox;
    Label4: TLabel;
    Label5: TLabel;
    PanelBtn: TPanel;
    BtnNew: TSpeedButton;
    BtnOpen: TSpeedButton;
    BtnSave: TSpeedButton;
    BtnPrint: TSpeedButton;
    BtnCut: TSpeedButton;
    BtnCopy: TSpeedButton;
    BtnPaste: TSpeedButton;
    BtnDelete: TSpeedButton;
    BtnTool: TSpeedButton;
    ImageEdit1: TImageEdit;
    DBImageEdit1: TDBImageEdit;
    DBImage1: TDBImage;
    BtnInfo: TButton;
    BtnQuit: TButton;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    procedure FormCreate(Sender: TObject);
    procedure DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure SpeedBtnClick(Sender: TObject);
    procedure TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure BtnQuitClick(Sender: TObject);
    procedure BtnInfoClick(Sender: TObject);
    procedure BtnToolClick(Sender: TObject);
    procedure ImageEdit1ShowToolbar(Sender: TObject);
    procedure FileListBox1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  FormDemo: TFormDemo;

{=============================================}

implementation

{$R *.DFM}

{----------------------------------------------
 Get windows-directory }

function GetWinDirStr:string;
var WinDirSz:array[0..128] of char;
    WinDirStr:string;
begin
  GetWindowsDirectory(WinDirSz,sizeof(WinDirSz));
  Result:=StrPas(WinDirSz);
end;

{----------------------------------------------}

procedure TFormDemo.FormCreate(Sender: TObject);
begin
  Button1.Enabled:=true;
  Button2.Enabled:=true;
  Button3.Enabled:=false;
  DirectoryListBox1.Directory:=GetWinDirStr;
end;

{----------------------------------------------}

procedure TFormDemo.SpeedBtnClick(Sender: TObject);
begin
  if      Sender = BtnNew then ImageEdit1.New(Sender)
  else if Sender = BtnOpen then ImageEdit1.OpenFile(Sender)
  else if Sender = BtnSave then ImageEdit1.SaveFile(Sender)
  else if Sender = BtnPrint then ImageEdit1.Print(Sender)
  else if Sender = BtnCut then ImageEdit1.ClipCut(Sender)
  else if Sender = BtnCopy then ImageEdit1.ClipCopy(Sender)
  else if Sender = BtnPaste then ImageEdit1.ClipPaste(Sender)
  else if Sender = BtnDelete then ImageEdit1.ClipDelete(Sender);
end;

{----------------------------------------------}

procedure TFormDemo.BtnToolClick(Sender: TObject);
begin
  if ImageEdit1.IsToolbarVisible
  then ImageEdit1.HideToolbar
  else ImageEdit1.ShowToolbar;
end;

{----------------------------------------------}

procedure TFormDemo.TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  ImageEdit1.HideToolbar;
  dbImageEdit1.HideToolbar;
end;

{----------------------------------------------}

procedure TFormDemo.DBNavigator1Click(Sender: TObject;
  Button: TNavigateBtn);
begin
  if Table1.State in [dsEdit, dsInsert] then begin
    Button1.Enabled:=true;
    Button2.Enabled:=false;
    Button3.Enabled:=true;
  end
  else begin
    Button1.Enabled:=true;
    Button2.Enabled:=true;
    Button3.Enabled:=false;
  end;
end;

{----------------------------------------------}

procedure TFormDemo.Button1Click(Sender: TObject);
begin
  Table1.Edit;
  DBImageEdit1.New(Sender);
  Button1.Enabled:=true;
  Button2.Enabled:=false;
  Button3.Enabled:=true;
end;

{----------------------------------------------}

procedure TFormDemo.Button2Click(Sender: TObject);
begin
  Table1.Edit;
  Button1.Enabled:=true;
  Button2.Enabled:=false;
  Button3.Enabled:=true;
end;

{----------------------------------------------}

procedure TFormDemo.Button3Click(Sender: TObject);
begin
  Table1.Post;
  Button1.Enabled:=true;
  Button2.Enabled:=true;
  Button3.Enabled:=false;
end;

{----------------------------------------------}

procedure TFormDemo.BtnQuitClick(Sender: TObject);
begin
  Close
end;

{----------------------------------------------}

procedure TFormDemo.BtnInfoClick(Sender: TObject);
var s:string;
    sz:array[0..128] of char;
begin
  s:=ExtractFilePath(Application.ExeName);
  s:=UpperCase(s+'imgedit.wri');
  if FileExists(s) then begin
    s:='write '+s;
    StrPCopy(sz,s);
    WinExec(sz, SW_SHOWNORMAL);
  end
  else ShowMessage('Documentation file '+s+' not found!')
end;

{----------------------------------------------}

procedure TFormDemo.ImageEdit1ShowToolbar(Sender: TObject);
var R:TRect;
begin
  { Get the absolute position of the Scrollbox }
  GetWindowRect(ScrollBox1.Handle, R);

  if ImageEdit1.Height<Scrollbox1.Height
  then ImageEdit1.ToolbarTop :=ImageEdit1.GetAbsoluteTop+ImageEdit1.Height
  else ImageEdit1.ToolbarTop :=R.Top+ScrollBox1.Height;
  ImageEdit1.ToolbarLeft:=ImageEdit1.GetAbsoluteLeft;
end;

{----------------------------------------------}

procedure TFormDemo.FileListBox1Click(Sender: TObject);
begin
  ImageEdit1.LoadFromFile(FileListBox1.Filename);
end;

end.
